/*
    Copyright (c) 2023 てくてく
    Released under the MIT license
    https://opensource.org/licenses/mit-license.php

    てくてく：https://techtech.witchserver.net/
    X（旧Twitter）：https://twitter.com/techtech_site
    管理人：とーれ
*/

$(function () {
    const ItemList = $('#itemList')
    const AddItemName = $('#addItemName');
    const AddItemBtn = $('#addItem');
    const TempText = $('#template');
    const ReplaceBtn = $('#novel2html');
    const Result = $('#result');
    const DefaultCount = 5;  // デフォルトの項目数
    const addInput = '<input type="text" class="item">'; // 追加されるinput

    // 項目追加
    AddItemBtn.on('click', function () {
        let itemName = AddItemName.val();
        if (itemName === '') {
            itemName = '未定義の項目';
        }

        // 削除ボタンの数で追加項目数を取得
        let count =  $('.removeItem').length;
        let itemCount = DefaultCount + count;
        let item = `<dt data-name = "item${itemCount}">${itemName} [item${itemCount}] <button type="button" class="removeItem">削除</button></dt>
                    <dd data-name = "item${itemCount}">${addInput}</dd>`;
        ItemList.append(item);
    })

    // 項目の削除
    $(document).on('click', '.removeItem', function () {
        let dataName = $(this).parent().attr('data-name');
        $(`[data-name = "${dataName}"]`).remove();
        Numbering();
    })

    // 項目の連番を再設定
    function Numbering(){
        $('dt[data-name]').each(function(index){
            let itemCount = DefaultCount + index;
            let html = $(this).html();
            html = html.replace(/(.*)\[item[0-9]\](.*)/g,`$1[item${itemCount}]$2`);
            $(this).html(html);
            $(this).attr('data-name',`[item${itemCount}]`);
        })
        $('dd[data-name]').each(function(index){
            let itemCount = DefaultCount + index;
            $(this).attr('data-name',`[item${itemCount}]`);
        })
    }

    // テンプレートファイルの読み込み
    $('#loadFile').change(function(){
        let file = $(this).prop('files')[0];
        let reader = new FileReader();
        reader.readAsText(file);
        reader.onload = function(){
            let text = reader.result;
            TempText.text(text);
        }
    })

    // 項目の置き換え
    ReplaceBtn.on('click', function () {
        let text = TempText.val();
        if (text === '') {
            alert('テンプレート設定がありません。');
        }

        // 項目をすべて置き換え
        let result = text;
        $('.item').each(function (index) {

            let itemText = $(this).val();

            // 小説本文のみ色々置き換え
            if ($(this).attr('id') === 'novel') {
                // 空行でのpタグ囲み
                if ($('#ptag').prop('checked')) {
                    let row = Number($('#row').val()) + 1;

                    let reg = new RegExp(`(\n|\r|\r\n){${row},}`,"g");
                    let arr = itemText.split(reg);
                    let tmp = "";
                    for (let i = 0; i < arr.length; i++) {
                        if(arr[i] === "\n"){
                            // pタグとpタグの間に水平タグを置く。
                            if($('#hr').prop('checked')){
                                tmp += "<hr>\n";
                            }
                            continue;
                        }
                        tmp += `<p>${arr[i]}</p>\n`;
                    }
                    itemText = tmp;
                }

                // 改行ありなら改行コードを入れる
                if ($('#break').prop('checked')) {
                    itemText = itemText.replace(/(\n|\r|\r\n)/g, "<br>\n");
                    if ($('#ptag').prop('checked')) {
                        itemText = itemText.replace(/\<\/p\>\<br\>/g,"</p>");
                    }
                    if($('#hr').prop('checked')){
                        itemText = itemText.replace(/\<hr\>\<br\>/g,"<hr>");
                    }
                }

                // ルビをタグに変換
                if ($('#ruby').prop('checked')) {
                    const ruby = [
                        /\|(.*)《(.*)》/g,          // | 漢字 《かんじ》
                        /\#(.*)__(.*)__\#/g,        // #漢字__かんじ__#
                        /\[RB:(.*),(.*)\]/g,        // [RB:漢字,かんじ]
                        /\[\[rb:(.*) > (.*)\]\]/g,  // [[rb: 漢字 > かんじ ]]
                        /\[(.*)"(.*)"\]/g           // [漢字"かんじ"]
                    ]
                    for (let i = 0; i < ruby.length; i++) {
                        itemText = itemText.replace(ruby[j], '<ruby><rb>$1</rb><rp>（</rp><rt>$2</rt><rp>）</rp></ruby>');
                    }
                }
            }

            let str = `[item${index}]`;
            result = result.replace(str, itemText);
        })
        Result.val(result);
    })

    // ファイル出力
    $('#output').on('click',function(){
        if($('#result').val().length === 0){
            alert('置き換え結果の中身がありません');
            return false;
        }
        let arr = $('#result').val().split('');
        let fileName = $('#fileName').val() === 0 ? $('#fileName').val():"output";
        let extention;
        let blob;
        if($('#html').prop('checked')){
            blob = new Blob(arr,{type:"text/html"});
            extention =".html"
        } else if($('#php').prop('checked')){
            blob = new Blob(arr,{type:"application/x-httpd-php"});
            extention =".php"
        }
        let link = document.createElement('a');
        link.href = URL.createObjectURL(blob);
        link.download = fileName + extention;
        link.click();
    })
})